import random

def ReadDict():
    #任何字都是单字词
    f1 = open('1word.csv')
    line = f1.readline()
    while line:
        data = line.split(',')
        if int(data[1]) > 4: #出现超过4次才纳入词库
            word1[data[0]] = float(data[2]) #word1['字'] = 0.0009
        line = f1.readline()
    f1.close()

    f2 = open('2word.csv')
    line = f2.readline()
    while line:
        data = line.split(',')
        p = float(data[2])
        if p > 4e-6: #概率大的双字词再纳入词库
            word2[data[0]] = float(data[2]) #word1['字'] = 0.0009
        line = f2.readline()
    f2.close()

try:
    from dict1 import word1,word2
except Exception as e:
    #读取词典内容（现直接通过py文件实现）
    word1 = dict()
    word2 = dict()
    ReadDict()
    #输出缓存dict1.py
    out = open("dict1.py",'w')
    out.write('#!/usr/bin/python3\n# -*- coding: gbk -*-\n')
    out.write('word1 = ')
    print(word1,file=out)
    out.write('word2 = ')
    print(word2,file=out)
    out.close()





#判断字符ch是否为汉字
def isKannji(ch):
    by = bytes(ch,encoding='gbk')
    #小于两个字节是英文字符
    if len(by) < 2:
        return False
    #排除各种符号
    if (by[0] >= 0xa1 and by[0] <= 0xa9):
        return False
    # if ch in ['，','；','。','、','：','！','【','】','■','‘','’','●','□','（','）']:
    #     return False

    return True

#判断古诗词中是否有不正常的字符
def Vaildpome(str):
    for ch in str:
    
        if ch in  ['，','；','。','、','：','！','‘','’','（','）','？']:
            continue
        by = bytes(ch,encoding='gbk')
        #小于两个字节是英文字符
        if len(by) < 2:
            return False
        #排除各种符号
        if (by[0] >= 0xa1 and by[0] <= 0xa9):
            return False
        # if ch in ['，','；','。','、','：','！','【','】','■','‘','’','●','□','（','）']:
        #     return False

    return True



#根据词牌名获取古诗内容
def GetbyName(name):
    r = list()
    f = open('ci.txt')
    try:
        line = f.readline()
    except:
        pass
    while line:
        sline = line.strip(' ')
        #判断词牌是否相同
        if sline.strip('\n') == name:
            #读取到是词内容的行再返回
            while len(sline) < 10:
                try:
                    line = f.readline()
                except:
                    pass
                sline = line.strip(' ').strip('\n')
            #诗词中出现非法字符时，重新读取诗词
            if not Vaildpome(sline):
                continue
            r.append(sline)
            
        else:
            try:
                line = f.readline()
            except:
                pass
    return r

#根据分词频率判断是单字词还是双字词
def divpome(p):
    #返回值是一个字符型数组
    r = list()
    ch0 = ''
    for ch in p:
        
        #标点符号直接插入
        if not isKannji(ch):
            if ch0 != '':
                r.append('1')

            r.append(ch)
            ch0 = ''
            continue
        #汉字
        #双字词
        if (ch0+ch) in word2:
            r.append('2')
            ch0 = ''
            continue
        #前一个字是非空时，判断为单字
        if ch0 != '':
            r.append('1')
        ch0 = ch
    return ''.join(r)

def GenPome(model):
    r = list()
    word1_list = list(word1.keys())
    word2_list = list(word2.keys())
    for ch in model:
        if ch == '1':
            r.append(random.choice(word1_list))
            continue
        if ch == '2':
            r.append(random.choice(word2_list))
            continue
        r.append(ch)
    return ''.join(r)
        
#根据词牌名获取分析古诗的模型
def GetPomeModel(name):
    pome = GetbyName(name)
    m = dict()
    for s in pome:
        model = divpome(s)
        if model in m:
            m[model] += 1
        else:
            m[model] = 1
    mmax = ''
    mmax_count = 0
    for model in m:
        if m[model] >= mmax_count:
            mmax_count = m[model]
            mmax = model
    print(pome)
    return mmax


from tkinter import * 

window = Tk()
window.title('宋词生成')
Label(window,text='词牌名：').grid(row=0,column=0)

name_in = Text(window,height=1, width=30)
name_in.grid(row=0,column=1)

pome_out = Text(window,height=10, width=30)
pome_out.grid(row=1,column=1)

def MakePome():

    #name = input('词牌名')
    name = name_in.get(0.0,END).strip(" ").strip('\n')
    
    model = GetPomeModel(name)
    print(model)
    output = GenPome(model)
    print(output)
    pome_out.delete(0.0, END)
    pome_out.insert(0.0,output)


Button(window,text='生成',command=MakePome).grid(row=0,column=2)

Label(window,text='结果:').grid(row=1,column=0)


mainloop()

